import flet as ft


def main(page: ft.Page):
    page.title = "Поддержка мобильных устройств Flet"
    page.scroll = ft.ScrollMode.AUTO

    title = ft.Text("3.5 Поддержка мобильных устройств", size=22, weight="bold")

    pc_requirements = ft.Column(
        [
            ft.Text("Условия для тестирования Flet-приложения на телефоне:", weight="bold"),
            ft.Text("• Python 3.7 или выше установлен на компьютере."),
            ft.Text("• Установлен пакет Flet:  pip install flet --upgrade"),
            ft.Text("• Команда flet доступна в PATH (flet --version)."),
            ft.Text("• Телефон и компьютер подключены к одной Wi-Fi/локальной сети."),
        ]
    )

    ios_block = ft.Column(
        [
            ft.Text("Тестирование на iOS (iPhone / iPad)", size=18, weight="bold"),
            ft.Text("1. Установить приложение Flet на iOS-устройство."),
            ft.Text("2. (Опционально) создать и активировать виртуальное окружение."),
            ft.Text("3. Создать проект:"),
            ft.Text("   flet create my-app"),
            ft.Text("   cd my-app", selectable=True),
            ft.Text("4. Запустить сервер разработки с поддержкой iOS:"),
            ft.Text("   flet run --ios", selectable=True),
            ft.Text("5. В терминале появится QR-код с URL проекта."),
            ft.Text("6. Открыть Camera на iPhone, навести на QR-код и нажать «Open in Flet»."),
            ft.Text("7. Разрешить доступ к локальной сети (Allow)."),
            ft.Text("8. При изменении main.py приложение мгновенно обновится на iOS-устройстве."),
            ft.Text("9. Вернуться на вкладку Home: тремя пальцами по экрану или встряхнуть iPhone."),
            ft.Text("Быстрый тест: можно открыть URL-счётчик:"),
            ft.Text("https://flet-counter-test-ios.fly.dev", selectable=True),
        ],
        spacing=3,
    )

    android_block = ft.Column(
        [
            ft.Text("Тестирование на Android", size=18, weight="bold"),
            ft.Text("1. Установить приложение Flet на устройство Android."),
            ft.Text("2. Убедиться, что компьютер и телефон в одной сети."),
            ft.Text("3. В папке проекта выполнить:"),
            ft.Text("   flet run --android", selectable=True),
            ft.Text("4. В терминале появится QR-код с URL проекта."),
            ft.Text("5. Открыть камеру или приложение Flet на Android и отсканировать QR-код."),
            ft.Text("6. Открыть проект в приложении Flet — он обновляется при изменении main.py."),
            ft.Text("7. Вернуться на вкладку Home: три пальца по экрану или встряхнуть устройство."),
            ft.Text("8. Можно вручную добавить проект по URL через кнопку «+» в приложении Flet."),
        ],
        spacing=3,
    )

    page.add(
        title,
        ft.Divider(),
        pc_requirements,
        ft.Divider(),
        ios_block,
        ft.Divider(),
        android_block,
    )


if __name__ == "__main__":
    ft.app(target=main)
